﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using System.Data;
using System.Web.Security.AntiXss;


public partial class FragmentDetails : BasePage
{
    LabResultsManager manager = new LabResultsManager();
    WorkflowCaseManager caseManager = new WorkflowCaseManager();
    LabOrderManager LabOrderMgr = new LabOrderManager();

    FRAGMENT_ANALYSI fragment;
    int AnalysisId;
    string CurAnalysisMethod;
    string CurrentAnalyte;
    string CurAnalysisTypeName;
    //int WKFCaseActivityId;

    public FragmentDetails()
    {
        manager.BOSaveSuccess += manager_BOSaveSuccess;

    }
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            int fragmentId;

            if (int.TryParse(Request.QueryString["fragmentId"], out fragmentId))
            {
                getRefreshFragment(fragmentId);
                SetupFragment();
            }
            else
            {
                BindGridView();
            }

            if (fragment != null && fragment.WKF_CASE_ACTIVITY.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.Accepted)
            {
                SaveButton.Enabled = false;

                if (GridViewAnalyteData.FooterRow != null)
                {
                    GridViewAnalyteData.FooterRow.Visible = false;
                    GridViewAnalyteData.Columns[0].Visible = false;
                }
                else
                {
                    if (GridViewAnalyteData.Controls.Count > 0)
                    {
                        GridViewAnalyteData.Controls[0].Controls[0].Visible = false;
                    }
                }
            }
        }

        int activityId;
        if (int.TryParse(Request.QueryString["activityId"], out activityId))
        {
            if (fragment == null)
            {

                BreadCrumbLabel.Text = "My Tasks > Lab Results > " + caseManager.getActivityByID(activityId).STD_WKFACTIVITYST.NAME + " > Workflow ID " + caseManager.getActivityByID(activityId).WKF_CASE_ID + " > Fragments > New";

            }
            else
            {
                BreadCrumbLabel.Text = AntiXssEncoder.HtmlEncode("My Tasks > Lab Results > " + caseManager.getActivityByID(activityId).STD_WKFACTIVITYST.NAME + " > Workflow ID " + caseManager.getActivityByID(activityId).WKF_CASE_ID + " > Fragments > Fragment ID > " + fragment.FRAGMENT_ID_NUMBER, false);

            }
        }


    }

    private void SetupFragment()
    {
        txtFragmentId.Text = fragment.FRAGMENT_ID_NUMBER;
        txtFragDesc.Text = fragment.FRAGMENT_DESCR;
        txtFragMass.Text = fragment.FRAGMENT_MASS_MEASURE;
        ddlMassmsrmts.SelectedIndex = ddlMassmsrmts.Items.IndexOf(ddlMassmsrmts.Items.FindByText(fragment.MASS_UNITS));
        //txtFragMassUnits.Text = fragment.MASS_UNITS;
        //txtDimensions.Text = Activity.FRAGMENT_ANALYSIs[0].DIMENSION_UNITS;
        //string[] Msrmnts = String.IsNullOrEmpty(fragment.FRAGMENT_LENGTH_MEASURE) ? ;
        txtLength.Text = String.IsNullOrEmpty(fragment.FRAGMENT_LENGTH_MEASURE) ? String.Empty : fragment.FRAGMENT_LENGTH_MEASURE.Split(' ')[0];

        if (!String.IsNullOrEmpty(fragment.FRAGMENT_LENGTH_MEASURE))
        {
            if (fragment.FRAGMENT_LENGTH_MEASURE.Split(' ').Length > 1)
            {
                ddlLengthmsrmts.SelectedValue = fragment.FRAGMENT_LENGTH_MEASURE.Split(' ')[1];
                //RequiredFieldValidatorDdlLengthmsrmts.Enabled = true;
            }

            txtHeight.Text = String.IsNullOrEmpty(fragment.FRAGMENT_HEIGHT_MEASURE) ? String.Empty : fragment.FRAGMENT_HEIGHT_MEASURE.Split(' ')[0];
        }

        if (!String.IsNullOrEmpty(fragment.FRAGMENT_HEIGHT_MEASURE))
        {

            if (fragment.FRAGMENT_HEIGHT_MEASURE.Split(' ').Length > 1)
            {
                ddlHeightmsrmts.SelectedValue = fragment.FRAGMENT_HEIGHT_MEASURE.Split(' ')[1];
                //RequiredFieldValidatorDdlHeightmsrmts.Enabled = true;
            }
            else
            {
                //RequiredFieldValidatorDdlHeightmsrmts.Enabled = false;
            }
        }

        //Msrmnts = GetMeasurement(Activity.FRAGMENT_ANALYSIs[0].FRAGMENT_WIDTH_MEASURE);

        if (!String.IsNullOrEmpty(fragment.FRAGMENT_WIDTH_MEASURE))
        {
            txtWidth.Text = String.IsNullOrEmpty(fragment.FRAGMENT_WIDTH_MEASURE) ? String.Empty : fragment.FRAGMENT_WIDTH_MEASURE.Split(' ')[0]; ;
            if (fragment.FRAGMENT_WIDTH_MEASURE.Split(' ').Length > 1)
            {
                ddlWidthmsrmts.SelectedValue = fragment.FRAGMENT_WIDTH_MEASURE.Split(' ')[1];
                //RequiredFieldValidatorDdlWidthmsrmts.Enabled = true;
            }
            else
            {
                //RequiredFieldValidatorDdlWidthmsrmts.Enabled = false;
            }
        }

        radRadioactive.SelectedValue = fragment.FRAGMENT_RADIOACTIVE_TEST_IND.ToString();

        txtRadActiveTestResult.Text = fragment.FRAGMENT_RADIOACTIVE_RESULT;
        txtComments.Text = fragment.COMMENT_TEXT;
        radTissueSent.SelectedValue = fragment.TISSUE_SENT_FLAG.ToString();
        txtTissueResults.Text = fragment.TISSUE_RESULT_TEXT;

        BindGridView();

    }


    private void SaveCompleteFragment()
    {


        if (fragment != null)
        {
            fragment.SetAsChangeTrackingRoot(true);
            SaveFragment();

        }
        else
        {
            fragment = AddNewFragment();
            fragment.SetAsChangeTrackingRoot(true);
            SaveFragment();
            fragment.SetAsInsertOnSubmit();

        }
        //set questionnaire in-process status


        manager.UpdateFragment(fragment);
        //(this.Master as RegistryMaster).SetDirtyFlag(false);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }

        getRefreshFragment(fragment.FRAGMENT_ANALYSIS_ID);
        SetupFragment();

        int activityId;
        if (int.TryParse(Request.QueryString["activityId"], out activityId))
        {

            BreadCrumbLabel.Text = AntiXssEncoder.HtmlEncode("My Tasks > Lab Results > " + caseManager.getActivityByID(activityId).STD_WKFACTIVITYST.NAME + " > Workflow ID " + activityId + " > Fragments > Fragment ID > " + fragment.FRAGMENT_ID_NUMBER, false);

        }

    }
    private void SaveFragment()
    {

        fragment.FRAGMENT_ID_NUMBER = txtFragmentId.Text;
        fragment.FRAGMENT_DESCR = txtFragDesc.Text;
        fragment.FRAGMENT_MASS_MEASURE = txtFragMass.Text;
        fragment.MASS_UNITS = ddlMassmsrmts.SelectedValue;
        //fragment.DIMENSION_UNITS = txtDimensions.Text;
        fragment.FRAGMENT_LENGTH_MEASURE = txtLength.Text + ' ' + ddlLengthmsrmts.SelectedValue;
        fragment.FRAGMENT_HEIGHT_MEASURE = txtHeight.Text + ' ' + ddlHeightmsrmts.SelectedValue;
        fragment.FRAGMENT_WIDTH_MEASURE = txtWidth.Text + ' ' + ddlWidthmsrmts.SelectedValue;
        fragment.FRAGMENT_RADIOACTIVE_TEST_IND = Helpers.ToNullable<char>(radRadioactive.SelectedValue);
        fragment.FRAGMENT_RADIOACTIVE_RESULT = txtRadActiveTestResult.Text;
        fragment.COMMENT_TEXT = txtComments.Text;
        if (radTissueSent.SelectedValue != "") fragment.TISSUE_SENT_FLAG = Convert.ToBoolean(radTissueSent.SelectedValue);
        fragment.TISSUE_RESULT_TEXT = txtTissueResults.Text;

        //fragment.WKF_CASE_ACTIVITY.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.Voided); 
        int activityId;

        if (int.TryParse(Request.QueryString["activityId"], out activityId))
        {
            WKF_CASE_ACTIVITY activity = caseManager.getActivityByID(activityId);

            activity = SerializerUtil.Deserialize<WKF_CASE_ACTIVITY>(activity.Serialize());
            activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.InProcess);

            //SuppressSaveSuccessMessage = true;
            caseManager.Update(activity);

        }

    }

    private void getRefreshFragment(int fragId)
    {
        fragment = manager.getFragByFragmentID(fragId);
        if (fragment != null)
        {
            fragment.SetAsChangeTrackingRoot();
        }
    }

    private void BindGridView()
    {
        bool enableAddButton = false;
        if (fragment != null)
        {
            if (fragment.ANALYSIS_DETAILs.Count() > 0)
            {
                GridViewAnalyteData.DataSource = fragment.ANALYSIS_DETAILs;
            }
            else
            {
                GridViewAnalyteData.DataSource = new List<ANALYSIS_DETAIL>();
            }
            enableAddButton = true;
        }
        else
        {
            GridViewAnalyteData.DataSource = new List<ANALYSIS_DETAIL>();
            enableAddButton = false;
        }

        GridViewAnalyteData.DataBind();
        EnableAddAnlyteButton(enableAddButton);
    }

    private void EnableAddAnlyteButton(bool enable)
    {
        Button addAnalyteButton = null;
        if (GridViewAnalyteData.FooterRow != null)
        {
            addAnalyteButton = GridViewAnalyteData.FooterRow.FindControl("btnAddAnalyte") as Button;
        }
        if (addAnalyteButton == null)
        {
            if (GridViewAnalyteData.Controls.Count > 0)
            {
                addAnalyteButton = GridViewAnalyteData.Controls[0].Controls[0].FindControl("btnedtAddAnalyte") as Button;
            }
        }
        if (addAnalyteButton != null)
        {
            addAnalyteButton.Enabled = enable;
        }
    }

    //gridview events
    protected void GridViewAnalyteData_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        DropDownList ddlMethods = (DropDownList)e.Row.FindControl("ddlMethodDesc");
        if (ddlMethods != null)
            ddlMethods.SelectedIndex = ddlMethods.Items.IndexOf(ddlMethods.Items.FindByText(CurAnalysisMethod));
        //if (CurAnalysisMethod != null)
        //{
        //    TextBox OthrBox = (TextBox)e.Row.FindControl("txtOthrAnalysisMthdTxt");
        //    if (OthrBox != null)
        //    {
        //        if (CurAnalysisMethod.ToUpper() == "OTHER")
        //            OthrBox.Visible = true;
        //        else
        //            OthrBox.Visible = false;
        //    }
        //}

        DropDownList ddlAnalytes = (DropDownList)e.Row.FindControl("ddlAnalytes");
        if (ddlAnalytes != null)
            ddlAnalytes.SelectedIndex = ddlAnalytes.Items.IndexOf(ddlAnalytes.Items.FindByText(CurrentAnalyte));
        //if (CurrentAnalyte != null)
        //{
        //    TextBox OthrBox = (TextBox)e.Row.FindControl("txtAnalyte");
        //    if (OthrBox != null)
        //    {
        //        if (CurrentAnalyte.ToUpper() == "OTHER")
        //            OthrBox.Visible = true;
        //        else
        //            OthrBox.Visible = false;
        //    }
        //}

        DropDownList ddlMethodTypes = (DropDownList)e.Row.FindControl("ddlMethodType");

        if (ddlMethodTypes != null)
        {
            ddlMethodTypes.SelectedIndex = ddlMethodTypes.Items.IndexOf(ddlMethodTypes.Items.FindByText(CurAnalysisTypeName));

            if (ddlMethodTypes.SelectedValue == "Other")
            {

            }
        }

        //if (e.Row.RowType == DataControlRowType.DataRow)
        //{
        //    Button Btn = (Button)e.Row.Cells[0].Controls[2];
        //    if (Btn.Text == "Delete")
        //        Btn.OnClientClick = "return confirm('Are you sure you want to delete this analyte?');";
        //}
    }

    protected void GridViewAnalyteData_RowEditing(object sender, GridViewEditEventArgs e)
    {

        GridViewAnalyteData.EditIndex = e.NewEditIndex;


        GridViewAnalyteData.SelectedIndex = GridViewAnalyteData.EditIndex;
        Label lblMethod = (Label)GridViewAnalyteData.Rows[e.NewEditIndex].FindControl("lblMethodDesc");
        CurAnalysisMethod = lblMethod.Text;

        Label lblAnalyte = (Label)GridViewAnalyteData.Rows[e.NewEditIndex].FindControl("lblAnalyte");
        CurrentAnalyte = lblAnalyte.Text;

        Label lblType = (Label)GridViewAnalyteData.Rows[e.NewEditIndex].FindControl("lblMethodType");
        CurAnalysisTypeName = lblType.Text;
        //BindData(WKFCaseActivityId, false);
        BindGridView();
        GridViewAnalyteData.FooterRow.Visible = false;
    }

    protected void GridViewAnalyteData_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        GridViewAnalyteData.EditIndex = -1;
        GridViewAnalyteData.SelectedIndex = -1;
        //BindData(WKFCaseActivityId, false);

        getRefreshFragment(fragment.FRAGMENT_ANALYSIS_ID);
        BindGridView();
        //SetupFragment();
        GridViewAnalyteData.FooterRow.Visible = true;
    }

    protected void GridViewAnalyteData_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        GridViewRow Row = GridViewAnalyteData.Rows[e.RowIndex];

        //fragment.WKF_CASE_ACTIVITY.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.InProcess);
        ANALYSIS_DETAIL AnalysisDetail = fragment.ANALYSIS_DETAILs.Where(d => d.ANALYSIS_DETAIL_ID == AnalysisId).SingleOrDefault();
        AnalysisDetail.SetAsChangeTrackingRoot(true);

        //        AnalysisDetail.SetAsUpdateOnSubmit();
        //        AnalysisDetail.SetAsChangeTrackingRoot();
        //AnalysisDetail.STD_ANALYSISMETHOD_ID = Convert.ToInt32(((DropDownList)Row.Cells[2].Controls[1]).SelectedValue);
        AnalysisDetail.STD_ANALYSISMETHOD_ID = Convert.ToInt32(((DropDownList)Row.FindControl("ddlMethodDesc")).SelectedValue);
        //AnalysisDetail.STD_FRAGMENT_ANALYSIS_TYPE_ID = Convert.ToInt32(((DropDownList)Row.Cells[3].Controls[1]).SelectedValue);
        AnalysisDetail.STD_FRAGMENT_ANALYSIS_TYPE_ID = Convert.ToInt32(((DropDownList)Row.FindControl("ddlMethodType")).SelectedValue);
        //AnalysisDetail.ANALYTE_NAME = ((TextBox)Row.Cells[1].Controls[1]).Text;
        //AnalysisDetail.RESULT_UNIT_NUMBER = ((TextBox)Row.Cells[4].Controls[1]).Text;
        //AnalysisDetail.RESULT_UNIT_NUMBER = ((TextBox)Row.Cells[4].Controls[1]).Text;
        //AnalysisDetail.RESULT_UNIT_NUMBER = ((TextBox)Row.FindControl("txtAnalytePercentage")).Text;
        //AnalysisDetail.EVAL_COMMENT_TEXT = ((TextBox)Row.Cells[5].Controls[1]).Text;
        AnalysisDetail.EVAL_COMMENT_TEXT = ((TextBox)Row.FindControl("txtComments")).Text;
        AnalysisDetail.RESULT_TEXT = ((TextBox)Row.FindControl("txtAnalytePercentage")).Text;
        //AnalysisDetail.CAS_NUMBER = ((TextBox)Row.Cells[6].Controls[1]).Text;
        AnalysisDetail.CAS_NUMBER = ((TextBox)Row.FindControl("txtCASNumber")).Text;

        AnalysisDetail.ANALYSIS_METHOD_NAME = ((TextBox)Row.FindControl("txtOthrAnalysisMthdTxt")).Text; //((TextBox)Row.Cells[2].Controls[3]).Text;
        AnalysisDetail.OTHER_ANALYTETYPE_NAME = ((TextBox)Row.FindControl("txtAnalyte")).Text;


        //AnalysisDetail.STD_ANALYTETYPE_ID = Convert.ToInt32(((DropDownList)Row.Cells[1].Controls[1]).SelectedValue);
        AnalysisDetail.STD_ANALYTETYPE_ID = Convert.ToInt32(((DropDownList)Row.FindControl("ddlAnalytes")).SelectedValue);

        //Save Analysis detail here
        //LabResultMgr.UpdateResultActivity(WCase);
        SuppressSaveSuccessMessage = true;
        manager.UpdateFragment(fragment);
        GridViewAnalyteData.EditIndex = -1;
        //BindData(Activity.WKF_CASE_ACTIVITY_ID, false);
        //HightlightMenu();// Status changed from New to InProcess (to support any changes made to db activity status directly)

        getRefreshFragment(fragment.FRAGMENT_ANALYSIS_ID);
        //SetupFragment();
        BindGridView();
        GridViewAnalyteData.FooterRow.Visible = true;
    }

    protected void GridViewAnalyteData_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        //Data key value is retrieved here. Row updating event returing null.
        if (e.CommandName == "Update" || e.CommandName == "Delete")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewAnalyteData.SelectedIndex = index;
            AnalysisId = Convert.ToInt32(GridViewAnalyteData.SelectedDataKey.Values[0]);
        }

        if (e.CommandName == "Edit")
        {
            gridViewEditModeFlag.Value = "1";

        }

        if (e.CommandName == "Cancel" || e.CommandName == "Update")
        {

            gridViewEditModeFlag.Value = "0";
        }
        if (e.CommandName == "Add" || e.CommandName == "AddNewRow")
        {
            gridViewAddNewModeFlag.Value = "1";
            //Deserialize();
            ANALYSIS_DETAIL AnalysisDetail = new ANALYSIS_DETAIL();
            AnalysisDetail.SetAsChangeTrackingRoot(true);
            //TextBox TxtAnalyte = null;
            if (e.CommandName == "Add")
            {
                AnalysisDetail.STD_ANALYSISMETHOD_ID = Convert.ToInt32(((DropDownList)GridViewAnalyteData.FooterRow.FindControl("ddlftrMethodDesc")).SelectedValue);
                AnalysisDetail.STD_FRAGMENT_ANALYSIS_TYPE_ID = Convert.ToInt32(((DropDownList)GridViewAnalyteData.FooterRow.FindControl("ddlftrMethodType")).SelectedValue);
                //AnalysisDetail.ANALYTE_NAME = ((TextBox)GridViewAnalyteData.FooterRow.FindControl("txtftrAnalyteNm")).Text;
                //AnalysisDetail.RESULT_UNIT_NUMBER = ((TextBox)GridViewAnalyteData.FooterRow.FindControl("txtftrAnalytePercentage")).Text;
                AnalysisDetail.RESULT_TEXT = ((TextBox)GridViewAnalyteData.FooterRow.FindControl("txtftrAnalytePercentage")).Text;
                AnalysisDetail.EVAL_COMMENT_TEXT = ((TextBox)GridViewAnalyteData.FooterRow.FindControl("txtftrComments")).Text;
                AnalysisDetail.CAS_NUMBER = ((TextBox)GridViewAnalyteData.FooterRow.FindControl("txtftrCASNumber")).Text;
                AnalysisDetail.ANALYSIS_METHOD_NAME = ((TextBox)GridViewAnalyteData.FooterRow.FindControl("txtftrOthrAnalysisMthdTxt")).Text;
                //TxtAnalyte = (TextBox)GridViewAnalyteData.FooterRow.FindControl("txtftrAnalyteNm");
                AnalysisDetail.OTHER_ANALYTETYPE_NAME = ((TextBox)GridViewAnalyteData.FooterRow.FindControl("txtftrAnalyteNm")).Text;
                AnalysisDetail.STD_ANALYTETYPE_ID = Convert.ToInt32(((DropDownList)GridViewAnalyteData.FooterRow.Cells[1].Controls[3]).SelectedValue);

            }
            else if (e.CommandName == "AddNewRow") // Empty template
            {
                var cmdSrc = e.CommandSource as Button;
                if (cmdSrc != null)
                {
                    GridViewRow Row = (GridViewRow)(cmdSrc.NamingContainer);
                    var ddledtMethodDesc = Row.FindControl("ddledtMethodDesc") as DropDownList;
                    if (ddledtMethodDesc != null)
                    {
                        AnalysisDetail.STD_ANALYSISMETHOD_ID = Convert.ToInt32(ddledtMethodDesc.SelectedValue);
                    }
                    var ddledtMethodType = Row.FindControl("ddledtMethodType") as DropDownList;
                    if (ddledtMethodType != null)
                    {
                        AnalysisDetail.STD_FRAGMENT_ANALYSIS_TYPE_ID = Convert.ToInt32(ddledtMethodType.SelectedValue);
                    }

                    //AnalysisDetail.ANALYTE_NAME = ((TextBox)Row.FindControl("txtedtAnalyteNm")).Text;
                    //AnalysisDetail.RESULT_UNIT_NUMBER = ((TextBox)Row.FindControl("txtedtAnalytePercentage")).Text;
                    AnalysisDetail.RESULT_TEXT = ((TextBox)Row.FindControl("txtedtAnalytePercentage")).Text;
                    AnalysisDetail.EVAL_COMMENT_TEXT = ((TextBox)Row.FindControl("txtedtComments")).Text;
                    AnalysisDetail.CAS_NUMBER = ((TextBox)Row.FindControl("txtedtCASNumber")).Text;
                    AnalysisDetail.ANALYSIS_METHOD_NAME = ((TextBox)Row.FindControl("txtedtOthrAnalysisMthdTxt")).Text;
                    //TxtAnalyte =(TextBox)Row.FindControl("txtedtAnalyteNm");
                    AnalysisDetail.OTHER_ANALYTETYPE_NAME = ((TextBox)Row.FindControl("txtedtAnalyteNm")).Text;
                    AnalysisDetail.STD_ANALYTETYPE_ID = Convert.ToInt32(((DropDownList)Row.FindControl("ddledtAnalytes")).SelectedValue);
                }

            }

            //Add a new fragment if it does not exist
            //if (Activity.FRAGMENT_ANALYSIs == null || Activity.FRAGMENT_ANALYSIs.Count() == 0)
            if (fragment == null)
            {
                //fragment.WKF_CASE_ACTIVITY.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.InProcess);
                //FRAGMENT_ANALYSI NewFragment = AddNewFragment();
                //NewFragment.SetAsChangeTrackingRoot(EntityState.New, true);
                fragment = AddNewFragment();
                fragment.SetAsChangeTrackingRoot(EntityState.New);
                //NewFragment.SetAsInsertOnSubmit(true);
                //NewFragment.ANALYSIS_DETAILs.Add(AnalysisDetail);
                //HightlightMenu();
                fragment.SetAsInsertOnSubmit(true);
                fragment.ANALYSIS_DETAILs.Add(AnalysisDetail);
            }
            else
            {
                //Activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.InProcess);
                AnalysisDetail.FRAGMENT_ANALYSIS_ID = fragment.FRAGMENT_ANALYSIS_ID;
                //Activity.FRAGMENT_ANALYSIs[0].ANALYSIS_DETAILs.Add(AnalysisDetail);
                //AnalysisDetail.SetAsChangeTrackingRoot(EntityState.New, true);
                fragment.ANALYSIS_DETAILs.Add(AnalysisDetail);
                AnalysisDetail.SetAsInsertOnSubmit();
            }
            //manager.UpdateResultActivity(WCase);
            SuppressSaveSuccessMessage = true;
            manager.UpdateFragment(fragment);
            GridViewAnalyteData.SelectedIndex = -1;
            //BindData(Activity.WKF_CASE_ACTIVITY_ID, false);
            //if (TxtAnalyte != null) TxtAnalyte.Focus();
            getRefreshFragment(fragment.FRAGMENT_ANALYSIS_ID);
            //SetupFragment(); 
            BindGridView();
            SuppressSaveSuccessMessage = true;
        }
    }


    protected void GridViewAnalyteData_RowCreated(object sender, GridViewRowEventArgs e)
    {

    }
    protected void GridViewAnalyteData_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {

        ANALYSIS_DETAIL AnalysisDetail = fragment.ANALYSIS_DETAILs.Where(d => d.ANALYSIS_DETAIL_ID == AnalysisId).SingleOrDefault();
        //Save Analysis detail here
        AnalysisDetail.SetAsChangeTrackingRoot(true);
        AnalysisDetail.SetAsDeleteOnSubmit(true);
        SuppressSaveSuccessMessage = true;
        manager.UpdateFragment(fragment);
        //Do not highlight the row
        GridViewAnalyteData.SelectedIndex = -1;
        //BindData(Activity.WKF_CASE_ACTIVITY_ID, false);
        getRefreshFragment(fragment.FRAGMENT_ANALYSIS_ID);
        //SetupFragment();
        BindGridView();
    }

    private FRAGMENT_ANALYSI AddNewFragment()
    {
        FRAGMENT_ANALYSI NewFragment = new FRAGMENT_ANALYSI();
        int activityId;

        if (int.TryParse(Request.QueryString["activityId"], out activityId))
        {
            NewFragment.WKF_CASE_ACTIVITY_ID = activityId;
            NewFragment.LAB_ORDER_ID = manager.GetLabOrderId(activityId);


        }
        NewFragment.RESULT_ACKNOWLEDGE_FLAG = false;
        //NewFragment.FRAGMENT_ANALYSIs.Add(NewFragment);
        return NewFragment;
    }


    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string fragmentXml = (string)ViewState["fragmentXml"];
        fragment = SerializerUtil.Deserialize<FRAGMENT_ANALYSI>(fragmentXml);

    }

    protected override object SaveViewState()
    {
        ViewState["fragmentXml"] = fragment.Serialize();
        return base.SaveViewState();

    }


    //protected void ODSAnalysisMethods_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    //{
    //    if (e.ReturnValue != null && !e.ReturnValue.GetType().IsValueType)
    //        if (((IEnumerable<STD_ANALYSISMETHOD>)e.ReturnValue).Count() > 0)
    //        {
    //            //GridViewVITASImplants.EmptyDataText = "No records found for the search criteria then you entered.";
    //            var analytes = (IEnumerable<STD_ANALYSISMETHOD>)e.ReturnValue;

    //        }
    //}

    protected void CancelButton_Click(object sender, EventArgs e)
    {
        int activityId;
        if (int.TryParse(Request.QueryString["activityId"], out activityId))
        {

            Response.Redirect("FragLabResultDetails.aspx?ActivityId={0}", activityId);
        }

    }

    protected void SaveButton_Click(object sender, EventArgs e)
    {
        HightlightMenu();
        SaveCompleteFragment();
        //SetupFragment();
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        //(this.Master as RegistryMaster).SetDirtyFlag(false);
    }


    private void HightlightMenu()
    {
        //Highlight the corresponding menu item
        //BreadCrumbLabel.Text = "Lab Results > In Process";
        Menu Mnu = (Menu)Master.FindControl("MenuLeftNavigation");
        bool Selected;
        MenuBuilder.SelectAndHighLightElement(Mnu.Items, "LabResults.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.InProcess), out Selected);
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "LabResults";
    }

    public override string AppObjectCode()
    {
        return "LabResults";
    }

}
